<?php
session_start();
/**
 * @package WordPress
 * @subpackage Default_Theme
*/
get_header();
?>
<div class="container">
  <div class="white1">
    <div class="row">
      <div class="col-lg-9">
        <div class="content text"> 
          <?php if (have_posts()) : ?>
		  <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
		  <?php /* If this is a category archive */ if (is_category()) { ?>
            <h2 class="pagetitle">Archive for the &#8216;<?php single_cat_title(); ?>&#8217; Category</h2>
          <?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
            <h2 class="pagetitle">Posts Tagged &#8216;<?php single_tag_title(); ?>&#8217;</h2>
          <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
            <h2 class="pagetitle">Archive for <?php the_time('F jS, Y'); ?></h2>
          <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
            <h2 class="pagetitle">Archive for <?php the_time('F, Y'); ?></h2>
          <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
            <h2 class="pagetitle">Archive for <?php the_time('Y'); ?></h2>
          <?php /* If this is an author archive */ } elseif (is_author()) { ?>
            <h2 class="pagetitle">Author Archive</h2>
          <?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
            <h2 class="pagetitle">Blog Archives</h2>
          <?php } ?>
          <div class="clearfix">&nbsp;</div>
		  <?php while (have_posts()) : the_post(); ?>
          <div class="row">
            <div class="col-md-2">
              <p><i class="fa fa-calendar fa-4x"></i></p>
              <p><?php the_time('M j, Y') ?></p>
              <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?>
            </div>
            <div class="col-md-10">
              <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
              <?php if(has_post_thumbnail()){ ?><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>" class="img-responsive blogimg" alt="<?php the_title(); ?>"><?php } ?>
              <?php the_excerpt(); ?>
              <a href="<?php the_permalink(); ?>" class="btn btn-primary">Read More <i class="fa fa-angle-right"></i></a>
            </div>
          </div>
          <hr>
          <?php endwhile; ?>
		  <?php else :
          if ( is_category() ) { // If this is a category archive
              printf("<p>Sorry, but there aren't any posts in the %s category yet.</p>", single_cat_title('',false));
          } else if ( is_date() ) { // If this is a date archive
              echo("<p>Sorry, but there aren't any posts with this date.</p>");
          } else if ( is_author() ) { // If this is a category archive
              $userdata = get_userdatabylogin(get_query_var('author_name'));
              printf("<p>Sorry, but there aren't any posts by %s yet.</p>", $userdata->display_name);
          } else {
              echo("<p>No posts found.</p>");
          }
		  endif;
	  	  ?>
        </div>
      </div>
      <?php get_sidebar(); ?>
    </div>
  </div>
</div>
<?php get_footer(); ?>