<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

// This line protects the file from being accessed by a URL directly.
defined('MOODLE_INTERNAL') || die();

// CCN Theme Constants
$string['pluginname'] = 'Edumy';
$string['configtitle'] = 'Edumy إعدادات';
$string['choosereadme'] = 'Edumy Premium Moodle Theme, Created by Cocoon.';
$string['ccn_settings_menu'] = 'خيارات';
$string['ccn_page_settings_menu'] = 'إعدادات الصفحة';
// CCN Plugin Constants: Backend
$string['config_title'] = 'العنوان';
$string['config_title_desc'] = 'العنوان الرئيسي الذي سيتم استخدامه للعنصر.';
$string['config_title_2'] = 'العنوان 2';
$string['config_subtitle'] = 'العنوان الفرعي';
$string['config_subtitle_desc'] = 'العنوان الفرعي للعنصر.';
$string['config_image'] = 'صورة';
$string['config_button_link'] = 'رابط الزر';
$string['config_button_text'] = 'نص الزر';
$string['config_button_target'] = 'زر target';
$string['config_button_type'] = 'نوع الزر';
$string['config_arrow_link'] = 'رابط السهم';
$string['config_link'] = 'ارتباط ال (URL)';
$string['config_link_desc'] = 'الرابط المراد استخدامه للعنصر. قم بتضمين http.';
$string['config_body'] = 'محتوى';
$string['config_number'] = 'رقم';
$string['config_text'] = 'نص';
$string['config_icon_class'] = 'الرمز';
$string['config_icon_class_desc'] = 'اختر الرمز لهذا العنصر';
$string['config_visibility'] = 'الظهور';
$string['config_visibility_desc'] = 'تهيئة ظهور العنصر';
$string['config_feature_1'] = 'الميزة 1';
$string['config_feature_2'] = 'الميزة 2';
$string['config_feature_3'] = 'الميزة 3';
$string['config_feature_4'] = 'الميزة 4';
$string['config_prev_1'] = 'سهم السابق (السطر 1)';
$string['config_prev_2'] = 'سهم السابق (السطر 2)';
$string['config_next_1'] = 'سهم التالي (السطر 1)';
$string['config_next_2'] = 'سهم التالي (السطر 2)';
$string['config_footer_text'] = 'نص التذييل';
$string['config_items'] = 'العناصر';
$string['config_item'] = 'العنصر ';
$string['config_date'] = 'التاريخ';
$string['config_location'] = 'الموقع';
$string['config_time'] = 'الزمن';
$string['config_zoom'] = 'تكبير';
$string['config_size'] = 'حجم';
$string['config_columns'] = 'أعمدة';
$string['config_end_date'] = 'تاريخ الانتهاء';
$string['config_users'] = 'المستخدمون';
$string['cocoon_block_settings'] = '[Cocoon] الإعدادات المتقدمة للقالب';
$string['config_ccn_margin_top'] = 'Margin top';
$string['config_ccn_margin_bottom'] = 'Margin bottom';
$string['config_ccn_padding_top'] = 'Padding top';
$string['config_ccn_padding_bottom'] = 'Padding bottom';
$string['config_ccn_css_class'] = 'Custom CSS Class';
$string['config_ccn_carousel_loop'] = 'Loop';
$string['config_ccn_carousel_lazyload'] = 'Lazyload images';
$string['config_ccn_carousel_animateout'] = 'Animate out';
$string['config_ccn_carousel_animatein'] = 'Animate in';
$string['config_ccn_margin_top'] = 'Margin top';
$string['config_ccn_margin_bottom'] = 'Margin bottom';
$string['config_ccn_padding_top'] = 'Padding top';
$string['config_ccn_padding_bottom'] = 'Padding bottom';
$string['config_ccn_css_class'] = 'Custom CSS Class';
$string['config_updated'] = 'محدث';
$string['config_rating'] = 'تقييم';
$string['config_description'] = 'وصف';
$string['config_enrolments'] = 'التسجيلات';
$string['config_newsitems'] = 'عناصر جديدة';
$string['config_price'] = 'السعر';
$string['config_enrol_btn'] = 'زر التسجيل';
$string['config_enrol_btn_text'] = 'نص زر التسجيل';
$string['config_autoplay'] = 'تشغيل تلقائي';
$string['config_speed'] = 'السرعة';
$string['config_loop'] = 'التكرار';
$string['config_teacher'] = 'المدرب';
$string['config_style'] = 'أسلوب';
$string['config_recaptcha'] = 'reCAPTCHA';
$string['config_yt'] = 'معرف فيديو يوتيوب';
$string['config_button_link_or_video'] = 'رابط  الزر. بدلاً من ذلك ، أدخل رابط لـ YouTube أو Vimeo لتمكين تراكب الفيديو.';
$string['config_color'] = 'لون';
$string['config_color_desc'] = 'اختر اللون المستخدم للعنصر.';
$string['config_line_break'] = 'سطر جديد';
$string['config_overrides'] = 'تجاوز القيم';
$string['config_body_type'] = 'نوع Body';
$string['config_body_plain'] = 'Body (plain text)';
$string['config_body_html'] = 'Body (HTML editor)';
$string['config_prev'] = 'السابق';
$string['config_next'] = 'التالي';
$string['config_arrow_style'] = 'شكل السهم';
$string['config_hover_text'] = 'نص التمرير';
$string['config_hover_accent'] = 'Hover accent';
$string['select_from_dropdown'] = 'برجاء اختيار عنصر من القائمة. أدناه';
$string['select_from_dropdown_multiple'] = 'برجاء اختيار عدة عناصر من القائمة أدناه ';
$string['config_featured_text'] = 'نص مميز';
$string['config_features'] = 'ميزات';
$string['config_features_help'] = 'ميزات جدول الأسعار. أدخل ميزة واحدة لكل سطر.';
$string['config_group_courses_filter'] = 'تفعيل التصفية';
$string['config_form'] = 'إعدادات النموذج';
$string['config_number_after'] = 'لاحقة الرقم';
$string['block_styles'] = '[Cocoon] شكل القالب';
$string['on_hover'] = ' (on hover)';
$string['border_radius'] = 'نصف قطر الحدود';
$string['config_countdown_date'] = 'تاريخ العد التنازلي';
$string['config_color_overlay'] = 'Overlay';
$string['config_color_hover'] = 'Hover';
$string['config_color_bg'] = 'خلفية';
$string['config_color_title'] = 'عنوان';
$string['config_color_subtitle'] = 'عنوان فرعي';
$string['config_color_body'] = 'محتوى';
$string['config_color_course_card'] = 'بطاقة الدورة';
$string['config_color_course_title'] = 'عنوان الدورة';
$string['config_color_course_price'] = 'سعر الدورة';
$string['config_color_course_enrol_btn'] = 'زر التسجيل بالمقرر';
$string['config_color_icon'] = 'رمز';
$string['config_color_text'] = 'نص';
$string['config_color_btn'] = 'زر';
$string['config_color_button'] = 'زر';
$string['config_video'] = 'فيديو';
$string['config_countdown_date'] = 'تاريخ العد التنازلي';
$string['config_button'] = 'زر';
$string['config_color_panel_bg'] = 'خلفية لوحة';
$string['config_color_panel_title'] = 'عنوان اللوحة';
$string['config_color_panel_subtitle'] = 'العنوان الفرعي للوحة';
$string['config_color_panel_body'] = 'محتوى اللوحة';
$string['config_form_title'] = 'عنوان النموذج';
$string['config_color_item_title'] = 'عنوان العنصر';
$string['config_color_item_body'] = 'محتوى العنصر';
$string['config_c_ccn_ic'] = 'خلفية العنصر';
$string['config_c_ccn_i'] = 'الرمز';
$string['config_c_ccn_it'] = 'عنوان العنصر';
$string['config_c_ccn_ib'] = 'محتوى العنصر';
$string['config_c_ccn_ibt'] = 'زر العنصر';
$string['config_child_categories'] = 'إظهار الفئات الفرعية';
$string['config_box_shadow'] = 'ظل الصندوق';

// CCN Plugin Constants: Frontend
$string['search_string'] = 'ابحث عن البرنامج أو المهارات التي تريد تعلمها';
$string['updated'] = 'تم التحديث';
$string['events'] = 'الأحداث';
$string['event'] = 'حدث';
$string['rated_by'] ='{$a} تقييم الطالب';
$string['rate_course'] ='تقديم التقييم';
$string['number_of_courses'] ='أكثر {$a} دورة/دورات';
$string['number_of_subcategories'] ='أكثر {$a} دورة/دورات';
$string['categories'] = 'فئات';
$string['hidden'] ='مخفي';
$string['back_to_course'] ='العودة للدورة';
$string['back_to_site'] ='العودة إلى الموقع';
$string['course_navigation'] ='التنقل في الدورة';
$string['rating_success'] ='اكتمل التقييم!';
// CCN Dashboard Constants
$string['messages_desc'] = 'تواصل';
$string['messages_title'] = 'رسائل';
$string['profile_desc'] = 'ملفك الشخصي';
$string['profile_title'] = 'الملف الشخصي';
$string['preferences_desc'] = 'التفضيلات';
$string['preferences_title'] = 'إعدادات';
$string['grades_desc'] = 'أداء';
$string['grades_title'] = 'تقديرات';
// CCN Regions
$string['region-side-pre'] = 'الشريط الجانبي الأيمن';
$string['region-left'] = 'الشريط الجانبي الأيسر';
$string['region-user-notif'] = 'إشعارات المستخدم';
$string['region-user-messages'] = 'رسائل المستخدم';
$string['region-fullwidth-top'] = 'عرض كامل بالأعلى';
$string['region-fullwidth-bottom'] = 'عرض كامل بالأسفل';
$string['region-above-content'] = 'فوق المحتوى';
$string['region-below-content'] = 'أسفل المحتوى';
$string['region-login'] = 'منطقة تسجيل الدخول';
$string['region-register'] = 'منطقة التسجيل';
$string['region-search'] = 'منطقة البحث';
$string['region-library-list'] = 'قائمة المكتبة';
$string['region-navbar'] = 'شريط التنقل';
// CCN Theme Settings
$string['headerlogo1'] = 'Header logo (Light)';
$string['headerlogo1_desc'] = 'The light variant of your website logo.';
$string['headerlogo2'] = 'Header logo (Dark)';
$string['headerlogo2_desc'] = 'The dark variant of your website logo.';
$string['headerlogo3'] = 'Header logo (Large)';
$string['headerlogo3_desc'] = 'The large variant of your website logo.';
$string['headerlogo_mobile'] = 'Header logo (Mobile)';
$string['headerlogo_mobile_desc'] = 'The mobile variant of your website logo (optional).';
$string['footerlogo1'] = 'Footer logo';
$string['footerlogo1_desc'] = 'The footer logo for your website.';
$string['cocoon_copyright'] = 'Copyright notice';
$string['cocoon_copyright_desc'] = 'The copyright notice for your website.';
$string['social_settings'] = 'Social';
$string['cocoon_facebook_url'] = 'Facebook URL';
$string['cocoon_facebook_url_desc'] = 'The link to your company\'s Facebook profile.';
$string['cocoon_twitter_url'] = 'Twitter URL';
$string['cocoon_twitter_url_desc'] = 'The link to your company\'s Twitter profile.';
$string['cocoon_instagram_url'] = 'Instagram URL';
$string['cocoon_instagram_url_desc'] = 'The link to your company\'s Instagram profile.';
$string['cocoon_dribbble_url'] = 'Dribbble URL';
$string['cocoon_dribbble_url_desc'] = 'The link to your company\'s Dribbble profile.';
$string['cocoon_pinterest_url'] = 'Pinterest URL';
$string['cocoon_pinterest_url_desc'] = 'The link to your company\'s Pinterest profile.';
$string['cocoon_google_url'] = 'Google URL';
$string['cocoon_google_url_desc'] = 'The link to your company\'s Google profile.';
$string['cocoon_youtube_url'] = 'YouTube URL';
$string['cocoon_youtube_url_desc'] = 'The link to your company\'s YouTube profile.';
$string['cocoon_vk_url'] = 'VK URL';
$string['cocoon_vk_url_desc'] = 'The link to your company\'s VK profile.';
$string['cocoon_500px_url'] = '500px URL';
$string['cocoon_500px_url_desc'] = 'The link to your company\'s 500px profile.';
$string['cocoon_behance_url'] = 'Behance URL';
$string['cocoon_behance_url_desc'] = 'The link to your company\'s Behance profile.';
$string['cocoon_digg_url'] = 'Digg URL';
$string['cocoon_digg_url_desc'] = 'The link to your company\'s Digg profile.';
$string['cocoon_flickr_url'] = 'Flickr URL';
$string['cocoon_flickr_url_desc'] = 'The link to your company\'s Flickr profile.';
$string['cocoon_foursquare_url'] = 'Foursquare URL';
$string['cocoon_foursquare_url_desc'] = 'The link to your company\'s Foursquare profile.';
$string['cocoon_linkedin_url'] = 'LinkedIn URL';
$string['cocoon_linkedin_url_desc'] = 'The link to your company\'s LinkedIn profile.';
$string['cocoon_medium_url'] = 'Medium URL';
$string['cocoon_medium_url_desc'] = 'The link to your company\'s Medium profile.';
$string['cocoon_meetup_url'] = 'Meetup URL';
$string['cocoon_meetup_url_desc'] = 'The link to your company\'s Meetup profile.';
$string['cocoon_snapchat_url'] = 'Snapchat URL';
$string['cocoon_snapchat_url_desc'] = 'The link to your company\'s Snapchat profile.';
$string['cocoon_tumblr_url'] = 'Tumblr URL';
$string['cocoon_tumblr_url_desc'] = 'The link to your company\'s Tumblr profile.';
$string['cocoon_vimeo_url'] = 'Vimeo URL';
$string['cocoon_vimeo_url_desc'] = 'The link to your company\'s Vimeo profile.';
$string['cocoon_wechat_url'] = 'WeChat URL';
$string['cocoon_wechat_url_desc'] = 'The link to your company\'s WeChat profile.';
$string['cocoon_whatsapp_url'] = 'WhatsApp URL';
$string['cocoon_whatsapp_url_desc'] = 'The link to your company\'s WhatsApp profile.';
$string['cocoon_wordpress_url'] = 'WordPress URL';
$string['cocoon_wordpress_url_desc'] = 'The link to your company\'s WordPress profile.';
$string['cocoon_weibo_url'] = 'Weibo URL';
$string['cocoon_weibo_url_desc'] = 'The link to your company\'s Weibo profile.';
$string['cocoon_telegram_url'] = 'Telegram URL';
$string['cocoon_telegram_url_desc'] = 'The link to your company\'s Telegram profile.';
$string['cocoon_moodle_url'] = 'Moodle URL';
$string['cocoon_moodle_url_desc'] = 'The link to your company\'s Moodle profile.';
$string['cocoon_amazon_url'] = 'Amazon URL';
$string['cocoon_amazon_url_desc'] = 'The link to your company\'s Amazon profile.';
$string['cocoon_slideshare_url'] = 'SlideShare URL';
$string['cocoon_slideshare_url_desc'] = 'The link to your company\'s SlideShare profile.';
$string['cocoon_soundcloud_url'] = 'Soundcloud URL';
$string['cocoon_soundcloud_url_desc'] = 'The link to your company\'s Soundcloud profile.';
$string['cocoon_leanpub_url'] = 'Leanpub URL';
$string['cocoon_leanpub_url_desc'] = 'The link to your company\'s Leanpub profile.';
$string['cocoon_xing_url'] = 'Xing URL';
$string['cocoon_xing_url_desc'] = 'The link to your company\'s Xing profile.';
$string['cocoon_bitcoin_url'] = 'Bitcoin URL';
$string['cocoon_bitcoin_url_desc'] = 'The link to your company\'s Bitcoin profile.';
$string['cocoon_twitch_url'] = 'Twitch URL';
$string['cocoon_twitch_url_desc'] = 'The link to your company\'s Twitch profile.';
$string['cocoon_github_url'] = 'Github URL';
$string['cocoon_github_url_desc'] = 'The link to your company\'s Github profile.';
$string['cocoon_gitlab_url'] = 'Gitlab URL';
$string['cocoon_gitlab_url_desc'] = 'The link to your company\'s Gitlab profile.';
$string['cocoon_forumbee_url'] = 'Forumbee URL';
$string['cocoon_forumbee_url_desc'] = 'The link to your company\'s Forumbee profile.';
$string['cocoon_trello_url'] = 'Trello URL';
$string['cocoon_trello_url_desc'] = 'The link to your company\'s Trello profile.';
$string['cocoon_weixin_url'] = 'Weixin URL';
$string['cocoon_weixin_url_desc'] = 'The link to your company\'s Weixin profile.';
$string['cocoon_slack_url'] = 'Slack URL';
$string['cocoon_slack_url_desc'] = 'The link to your company\'s Slack profile.';
$string['header_settings'] = 'Header';
$string['headertype'] = 'Header style';
$string['headertype_desc'] = 'Select the header style for the website. Note that some fields below only apply to certain header styles.';
$string['email_address'] = 'Email address';
$string['email_address_desc'] = 'Your company\'s email address.';
$string['phone'] = 'Telephone';
$string['phone_desc'] = 'Your company\'s telephone number.';
$string['cta_text'] = 'Call-to-action text';
$string['cta_text_desc'] = 'The call-to-action text that should be displayed.';
$string['cta_link'] = 'Call-to-action link';
$string['cta_link_desc'] = 'The link for the call-to-action.';
$string['cta_icon'] = 'Call-to-action icon';
$string['cta_icon_desc'] = 'The icon for the call-to-action.';
$string['footer_settings'] = 'Footer';
$string['footertype'] = 'Footer style';
$string['footertype_desc'] = 'Select the footer style for the website. Note that some fields below only apply to certain footer styles.';
$string['footer_col_1'] = 'Footer column 1';
$string['footer_col_2'] = 'Footer column 2';
$string['footer_col_3'] = 'Footer column 3';
$string['footer_col_4'] = 'Footer column 4';
$string['footer_col_5'] = 'Footer column 5';
$string['footer_col_title'] = 'Column title';
$string['footer_col_title_desc'] = 'The title for the footer column.';
$string['footer_col_body'] = 'Column body';
$string['footer_col_body_desc'] = 'The body for the footer column. HTML is allowed.';
$string['footer_menu'] = 'Footer menu';
$string['footer_menu_desc'] = 'The content for the footer menu. HTML is allowed.';
$string['general_settings'] = 'General';
$string['blogstyle'] = 'Blog style';
$string['blogstyle_desc'] = 'The style for the website blog.';
$string['courseliststyle'] = 'Course list style';
$string['courseliststyle_desc'] = 'The style for the course category view.';
$string['advanced_settings'] = 'Advanced';
$string['custom_css'] = 'Custom CSS';
$string['custom_css_desc'] = 'Your custom CSS, loaded only on the front-end.';
$string['custom_css_dashboard'] = 'Custom CSS (Dashboard)';
$string['custom_css_dashboard_desc'] = 'Your custom CSS, loaded only on the dashboard.';
$string['custom_css_h5p'] = 'Custom CSS (H5P)';
$string['custom_css_h5p_desc'] = 'Your custom CSS, loaded only within H5P activities.';
$string['custom_js'] = 'Custom JavaScript';
$string['custom_js_desc'] = 'Your custom JavaScript, loaded only on the front-end.';
$string['custom_js_dashboard'] = 'Custom JavaScript (Dashboard)';
$string['custom_js_dashboard_desc'] = 'Your custom JavaScript, loaded only on the dashboard.';
$string['user_settings'] = 'Users';
$string['user_custf_other'] = '"Other fields" placement';
$string['user_custf_other_desc'] = 'Customize the placement of "Other fields" custom profile fields on user edit pages.';
$string['heading_bg'] = 'Page heading background';
$string['heading_bg_desc'] = 'The background image for the page heading/breadcrumb hero.';
$string['login_bg'] = 'Login background';
$string['login_bg_desc'] = 'The background image for the login & registration page.';
$string['logotype'] = 'Logotype visibility';
$string['logotype_desc'] = 'Display the logotype beside the logo image?';
$string['logo_image'] = 'Logo image visibility';
$string['logo_image_desc'] = 'Display the logo image?';
$string['logotype_footer'] = 'Footer logotype visibility';
$string['logotype_footer_desc'] = 'Display the logotype beside the footer logo image?';
$string['logo_image_footer'] = 'Footer logo image visibility';
$string['logo_image_footer_desc'] = 'Display the footer logo image?';
$string['color_settings'] = 'Color';
$string['color_settings_gradient'] = 'Gradient';
$string['color_gradient_start'] = 'Gradient start';
$string['color_gradient_start_desc'] = 'The color for the start of the gradient.';
$string['color_gradient_end'] = 'Gradient end';
$string['color_gradient_end_desc'] = 'The color for the end of the gradient.';
$string['color_settings_main'] = 'Common colors';
$string['color_primary'] = 'Primary color';
$string['color_primary_desc'] = 'The primary color used throughout the site.';
$string['color_primary_alternate'] = 'Primary color (alternate)';
$string['color_primary_alternate_desc'] = 'The alternate primary color used throughout the site.';
$string['color_secondary'] = 'Secondary color';
$string['color_secondary_desc'] = 'The secondary color used throughout the site.';
$string['color_accent'] = 'Accent color';
$string['color_accent_desc'] = 'The accent color used to highlight specific elements.';
$string['color_accent_2'] = 'Second accent color';
$string['color_accent_2_desc'] = 'The second accent color used to highlight specific elements.';
$string['color_accent_3'] = 'Third accent color';
$string['color_accent_3_desc'] = 'The third accent color used to highlight specific elements.';
$string['color_accent_4'] = 'Fourth accent color';
$string['color_accent_4_desc'] = 'The fourth accent color used to highlight specific elements.';
$string['color_settings_header_style_2'] = 'Header colors (style 2)';
$string['color_settings_header_style_3'] = 'Header colors (style 3)';
$string['color_settings_header_style_4'] = 'Header colors (style 4)';
$string['color_settings_header_style_5'] = 'Header colors (style 5)';
$string['color_settings_header_style_6'] = 'Header colors (style 6)';
$string['color_header_color'] = 'Header color';
$string['color_header_color_desc'] = 'The color for the header.';
$string['color_header_color_top'] = 'Header top';
$string['color_header_color_top_desc'] = 'The color for the header top.';
$string['color_header_color_bottom'] = 'Header bottom';
$string['color_header_color_bottom_desc'] = 'The color for the header bottom.';
$string['color_settings_footer_style_1'] = 'Footer colors (style 1)';
$string['color_settings_footer_style_2'] = 'Footer colors (style 2)';
$string['color_settings_footer_style_3'] = 'Footer colors (style 3)';
$string['color_settings_footer_style_5'] = 'Footer colors (style 5)';
$string['color_settings_footer_style_6'] = 'Footer colors (style 6)';
$string['color_settings_footer_style_7'] = 'Footer colors (style 7)';
$string['color_footer_color_top'] = 'Footer top';
$string['color_footer_color_top_desc'] = 'The color for the footer top.';
$string['color_footer_color_middle'] = 'Footer middle';
$string['color_footer_color_middle_desc'] = 'The color for the footer middle.';
$string['color_footer_color_bottom'] = 'Footer bottom';
$string['color_footer_color_bottom_desc'] = 'The color for the footer bottom.';
$string['color_footer_color'] = 'Footer color';
$string['color_footer_color_desc'] = 'The color for the footer.';
$string['gmaps_key'] = 'Google Maps API Key';
$string['gmaps_key_desc'] = 'Your Google Maps API Key';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'The favicon for the website. Recommended size is 16 x 16px.';
$string['library_list'] = 'Library list';
$string['library_list_desc'] = 'Display a library list (list of course categories) in the header.';
$string['logo_settings'] = 'Logo';
$string['header_logos'] = 'Header logos';
$string['footer_logos'] = 'Footer logos';
$string['header_search'] = 'Header search';
$string['header_search_desc'] = 'Settings for the search functionality in the header.';
$string['header_login'] = 'Header login';
$string['header_main_menu'] = 'Main menu';
$string['header_main_menu_desc'] = 'Visibility of the main navigation menu links.';
$string['header_login_desc'] = 'Settings for the login functionality in the header.';
$string['back_to_top'] = 'Back to Top';
$string['back_to_top_desc'] = 'Show or hide the back-to-top button on the frontend.';
$string['language_menu'] = 'Language menu';
$string['language_menu_desc'] = 'Settings for the language menu.';
$string['blog_post_author'] = 'Blog post author';
$string['blog_post_author_desc'] = 'Show or hide the author name on blog posts. This setting controls the blog listing page, individual blog posts, and all [Cocoon] blocks.';
$string['blog_post_date'] = 'Blog post date';
$string['blog_post_date_desc'] = 'Show or hide the date on blog posts. This setting controls the blog listing page, individual blog posts, and all [Cocoon] blocks.';
$string['headertype_settings'] = 'Header style settings';
$string['headertype_settings_desc'] = 'Select whether the header style should apply only to the frontpage, or to all pages throughout the site.';
$string['logo_image_width'] = 'Logo image width';
$string['logo_image_width_desc'] = 'The width in pixels for the header logo. Enter the numercial value only, and do not include "px".';
$string['logo_image_height'] = 'Logo image height';
$string['logo_image_height_desc'] = 'The height in pixels for the header logo. Enter the numercial value only, and do not include "px".';
$string['logo_image_width_footer'] = 'Footer logo image width';
$string['logo_image_width_footer_desc'] = 'The width in pixels for the footer logo. Enter the numercial value only, and do not include "px".';
$string['logo_image_height_footer'] = 'Footer logo image height';
$string['logo_image_height_footer_desc'] = 'The height in pixels for the footer logo. Enter the numercial value only, and do not include "px".';
$string['preloader_image'] = 'Preloader image';
$string['preloader_image_desc'] = 'The image to use for the preloader.';
$string['dashboard_settings'] = 'Dashboard';
$string['dashboard_settings_long'] = 'Dashboard settings';
$string['dashboard_icons'] = 'Dashboard icons';
$string['dashboard_icons_visibility'] = 'Dashboard icons visibility';
$string['dashboard_icons_visibility_desc'] = 'Show or hide the icons in the user dashboard.';
$string['icon_1'] = 'Icon 1';
$string['icon_2'] = 'Icon 2';
$string['icon_3'] = 'Icon 3';
$string['icon_4'] = 'Icon 4';
$string['dashboard_sticky_header'] = 'Sticky header';
$string['dashboard_sticky_header_desc'] = 'Settings for the dashboard sticky header.';
$string['dashboard_left_drawer'] = 'Dashboard left drawer';
$string['dashboard_left_drawer_desc'] = 'Visibility settings for the left navigation drawer in the Dashboard. Use the default Start menu, or use custom blocks instead. Alternatively, disable the left drawer entirely.';
$string['dashboard_sticky_drawer'] = 'Sticky left drawer';
$string['dashboard_sticky_drawer_desc'] = 'Keep the dashboard left drawer stuck to the screen, or scroll with the page.';
$string['primary_font'] = 'Primary font';
$string['primary_font_desc'] = 'The primary font used throughout the website.';
$string['secondary_font'] = 'Secondary font';
$string['secondary_font_desc'] = 'The secondary font used throughout the website.';
$string['color_tertiary'] = 'Tertiary color';
$string['color_tertiary_desc'] = 'The tertiary color used throughout the site.';
$string['color_parallax'] = 'Parallax color';
$string['color_parallax_desc'] = 'The parallax color used throughout the website.';
$string['course_settings'] = 'Course';
$string['course_settings_topics_format'] = 'Topics format';
$string['topics_format_collapsible'] = 'Collapsible settings';
$string['topics_format_collapsible_desc'] = 'Settings for the collapsible topics format.';
$string['breadcrumb_settings'] = 'Breadcrumb';
$string['breadcrumb_style'] = 'Breadcrumb style';
$string['breadcrumb_style_desc'] = 'The style of the inner page breadcrumb.';
$string['breadcrumb_caps'] = 'Breadcrumb capitalization';
$string['breadcrumb_caps_desc'] = 'The capitalization of the breadcrumb trail.';
$string['breadcrumb_clip'] = 'Clip breadcrumb text';
$string['breadcrumb_clip_desc'] = 'Configure the clipping or reducing of long text in the breadcrumb.';
$string['breadcrumb_title'] = 'Breadcrumb title';
$string['breadcrumb_title_desc'] = 'Display the breadcrumb title.';
$string['breadcrumb_trail'] = 'Breadcrumb navigation trail';
$string['breadcrumb_trail_desc'] = 'Display the breadcrumb navigation trail.';
$string['preloader_settings'] = 'Preloader';
$string['preloader_duration'] = 'Preloader duration';
$string['preloader_duration_desc'] = 'The length of time to display the preloader. It is highly recommended to leave this as the default. To accelarate loading time, we suggest compressing images prior to uploading.';
$string['course_content_enroled_only'] = 'Course Content access';
$string['course_content_enroled_only_desc'] = '(Topics format only) - Choose whether to display course content to all users, or only those enroled in the course. This is helpful you want to allow guest access to course pages, but hide the list of course content, topics, sections, and activity names from unenroled users.';
$string['social_target'] = 'Social URL window target';
$string['social_target_desc'] = 'Determine whether social URLs should open on the same page or in a new window.';
$string['coursecat_modified'] = 'Last updated';
$string['coursecat_modified_desc'] = 'Show the date that the course/category was last updated.';
$string['coursecat_enrolments'] = 'Course enrolments';
$string['coursecat_enrolments_desc'] = 'Show the number of students enroled in a course.';
$string['coursecat_announcements'] = 'Course news items';
$string['coursecat_announcements_desc'] = 'Show the number of course announcements in a course.';
$string['coursecat_settings'] = 'Course category settings';
$string['coursecat_prices'] = 'Course price';
$string['coursecat_prices_desc'] = 'Show course prices in category lists and blocks.';
$string['single_course_settings'] = 'Single course settings';
$string['course_single_style'] = 'Single course style';
$string['course_single_style_desc'] = 'Select the style to use on single courses.';
$string['course_start_date'] = 'Course start date';
$string['course_start_date_desc'] = 'Display the start date in single course pages, above the course content.';
$string['course_category'] = 'Course category';
$string['course_category_desc'] = 'Display the category in single course pages, above the course content.';
$string['seo'] = 'SEO';
$string['meta_description'] = 'Meta description';
$string['meta_description_desc'] = 'The meta description for your Moodle site.';
$string['meta_abstract'] = 'Meta abstract';
$string['meta_abstract_desc'] = 'The meta abstract for your Moodle site (the abstract tag is sometimes used for archiving of web pages or by educational establishments).';
$string['meta_keywords'] = 'Meta keywords';
$string['meta_keywords_desc'] = 'The meta keywords for your Moodle site.';
$string['incourse_layout'] = 'In course layout';
$string['incourse_layout_desc'] = 'The layout that should be used when a user is within a course (eg accessing individual course activities, resources, or content). Custom blocks may not be displayed when using the Dashboard layout.';
$string['coursemainpage_layout'] = 'Course main page layout';
$string['coursemainpage_layout_desc'] = 'The layout that should be used when a user is on a course main page. Custom blocks may not be displayed when using the Dashboard layout.';
$string['singlecourse_blocks'] = 'Course block visibility';
$string['singlecourse_blocks_desc'] = 'Choose whether to display blocks added to courses on all pages of the course, or only on the main course page. Use this setting to prevent blocks from appearing on similar course pages (such as the Participants page and User pages). This setting affects all blocks added to courses, not just Cocoon blocks.';
$string['user_profile_layout'] = 'User profile layout';
$string['user_profile_layout_desc'] = 'The layout that should be used for user profiles.';
$string['dashboard_layout'] = 'Dashboard layout';
$string['dashboard_layout_desc'] = 'The layout that should be used for dashboard pages.';
$string['login_layout'] = 'Login page layout';
$string['login_layout_desc'] = 'The layout that is used for login and registration pages.';
$string['edumy_homepage'] = 'Frontpage';
$string['edumy_homepage_desc'] = 'Settings for the frontpage layout';
$string['edumy_homepage_core'] = 'Frontpage sections';
$string['edumy_homepage_core_desc'] = 'Display Moodle core sections on the frontpage?';
$string['layout_settings'] = 'Layout';
$string['edumy_focus'] = 'Edumy Focus';
$string['edumy_focus_desc'] = 'Settings for Edumy Focus layouts.';
$string['edumy_focus_sidebar'] = 'Display navigation sidebar?';
$string['edumy_focus_sidebar_desc'] = 'Choose whether to display the activity sidebar in Edumy Focus layouts.';
$string['course_enrolment_payment'] = 'Course enrolment payment';
$string['course_enrolment_payment_desc'] = 'Settings for course enrolment preferences. Do all courses require payment, or are some free? This setting dictates how course enrolment will work and be displayed.';
$string['dashboard_tablet_1'] = 'Dashboard tablet 1';
$string['dashboard_tablet_2'] = 'Dashboard tablet 2';
$string['dashboard_tablet_3'] = 'Dashboard tablet 3';
$string['dashboard_tablet_4'] = 'Dashboard tablet 4';
$string['general_course_settings'] = 'General course settings';
$string['course_ratings'] = 'Course ratings';
$string['course_ratings_desc'] = 'Settings for course star ratings.';
$string['font_settings'] = 'Fonts';
$string['upload_font_woff'] = 'Font WOFF';
$string['upload_font_woff_desc'] = 'Upload the WOFF file for the custom font. Optional, but recommended.';
$string['upload_font_woff2_desc'] = 'Upload the WOFF2 file for the custom font. Optional, but recommended.';
$string['upload_font_ttf_desc'] = 'Upload the TTF file for the custom font. Optional, but recommended.';
$string['upload_font_eot_desc'] = 'Upload the EOT file for the custom font. Optional, but recommended.';
$string['upload_font_svg_desc'] = 'Upload the SVG file for the custom font. Optional, but recommended.';
$string['upload_font_woff2'] = 'Font WOFF2';
$string['upload_font_ttf'] = 'Font TTF';
$string['upload_font_eot'] = 'Font EOT';
$string['upload_font_svg'] = 'Font SVG';
$string['google_fonts'] = 'Google fonts';
$string['custom_font_primary'] = 'Custom font (primary)';
$string['custom_font_secondary'] = 'Custom font (secondary)';
$string['dashboard_header'] = 'Dashboard header';
$string['dashboard_header_desc'] = 'Configure the appearance of the dashboard header.';
$string['navigation_icon'] = 'Navigation icon';
$string['notification_icon'] = 'Notification icon';
$string['messages_icon'] = 'Messages icon';
$string['dark_mode_icon'] = 'Night Learning icon';
$string['profile_icon'] = 'Profile dropdown';
$string['profile_icon_username'] = 'Username appearance';
$string['profile_icon_username_desc'] = 'The appearance of the username in the profile dropdown in the main navigation bar.';
$string['page_settings_controls'] = 'Page Settings button';
$string['page_settings_controls_desc'] = 'Moodle sometimes displays the "Page Settings" button for Students and Guests. Here you can prevent it from displaying for these users.';
$string['select'] = 'Select';
$string['course_price_format'] = 'Price format';
$string['course_price_format_desc'] = 'The format for which prices should be displayed throughout the site.';
$string['live_customizer'] = 'Live customizer';
$string['icons'] = 'Icons';
$string['icons_desc'] = 'Edumy includes 4 iconsets that provide a total of 3000 icons. If you prefer less icons, disable iconsets here. Before disabling iconsets, please make sure that no fields are using icons from the disabled sets.';
$string['iconset_desc'] = 'Load this iconset';
$string['iconset_edumy'] = 'Edumy icons';
$string['iconset_cocoon'] = 'Cocoon icons';
$string['iconset_fontawesome'] = 'FontAwesome icons';
$string['iconset_lineawesome'] = 'LineAwesome icons';
$string['order_receipts'] = 'Order receipts';
$string['address_line_1'] = 'Address line 1';
$string['address_line_2'] = 'Address line 2';
$string['address_line_3'] = 'Address line 3';
$string['address_line_1_desc'] = 'The first line of your address.';
$string['address_line_2_desc'] = 'The second line of your address.';
$string['address_line_3_desc'] = 'The third line of your address.';
$string['zip_code'] = 'ZIP Code';
$string['zip_code_desc'] = 'Your ZIP code';
$string['for_developers'] = 'For Developers';
$string['for_developers_desc'] = 'Settings provided for developers to aid in further extension of Edumy theme.';
$string['dev_expose_blocks'] = 'Expose blocks';
$string['dev_expose_blocks_desc'] = 'Make all custom Cocoon blocks available on all site pages, including the user dashboard and site administration.';
$string['course_settings_activities'] = 'Activity modules';
$string['quiz_layout'] = 'Quiz layout';
$string['quiz_layout_desc'] = 'The layout of the quiz activity.';
$string['logo_url'] = 'Logo URL';
$string['logo_url_desc'] = 'Override the logo URL in all Edumy headers and footers.';

// CCN Fixes
$string['allexcepthidden'] = 'الكل ماعدا المخفي';

// Theme Edumy
$string['studentsiamteaching'] = 'طلاب أُدرس لهم';
$string['coursesiamteaching'] = 'دورات أقوم بتدريبها';
$string['coursesiamtaking'] = 'دوارات أدرسها';
$string['profileviews'] = 'مشاهدات ملفي الشخصي';
$string['socialmedia'] = 'التواصل الاجتماعي';
$string['accessed'] = 'الوصول';
$string['last_accessed'] = 'أخر وصول';
$string['last_accessed_courses'] = 'أخر مقررات قمت بزياراتها';
$string['select_no_cat'] = 'من فضلك قم باختيار عدد التصنيفات';
$string['navigation'] = 'التنقل';
$string['start'] = 'ابدأ';
$string['login_welcome'] = 'الدخول لحسابك';
$string['login'] = 'الدخول';
$string['login_no_account'] = 'ليس لديك حساب؟';
$string['signup'] = 'التسجيل!';
$string['search_courses'] = 'بحث الدورات...';
$string['forgot_password'] = 'هل نسيت كلمة المرور?';
$string['or'] = 'أو';
$string['login_register'] = 'الدخول/التسجيل';
$string['your_name'] = 'أسمك';
$string['your_name_requirements'] = '3 حروف أو مسافات على الأقل.';
$string['email_address'] = 'البريد الإلكتروني';
$string['email_address_requirements'] = 'بريد إلكتروني حقيقي.';
$string['subject'] = 'مواد';
$string['subject_requirements'] = 'خمسة حروف على الأقل.';
$string['message'] = 'رسالة';
$string['message_requirements'] = 'خمسة حروف على الأقل.';
$string['send'] = 'إرسال';
$string['lectures'] = 'محاضرات';
$string['quizzes'] = 'اختبارات';
$string['duration'] = 'المدة الزمنية';
$string['skill_level'] = 'مستوى المهارة';
$string['language'] = 'اللغة';
$string['assessments'] = 'التقييمات';
$string['last_updated'] = 'أخر تحديث';
$string['share'] = 'مشاركة';
$string['students_enrolled'] = 'الطلاب الملتحقين';
$string['topics'] = 'مواضيع';
$string['see_more'] = 'المزيد';
$string['course_enrolment'] = 'اشتري والتحق الأن';
$string['course_enrolment_free'] = 'انضم والتحق الأن';
$string['course_free_access'] = 'الالتحاق مجاني';
$string['course_free'] = 'مجانًا';
$string['course_free_accent'] = '100%';
$string['course_free_to_join'] = 'للانضمام';
$string['course_buy_access'] = 'دخول الدورة المدفوعة';
$string['course_enrolled'] = 'أنت مسجّل';
$string['course_enrolled_text'] = 'أنت مسجل حاليًا في هذه الدورة';
$string['course_enrolled_teacher'] = 'أنت تدرس';
$string['course_enrolled_teacher_text'] = 'أنت تقوم حاليًا بتدريس هذه الدورة.';
$string['course_error_title'] = 'خطأ بالتسجيل';
$string['course_error_text'] = 'لم يقم المسؤول لديك بإتمام إعدادات التسجيل ب PayPal أو Stripe لهذه الدورة التدريبية.';
$string['course_price'] = 'السعر';
$string['course_currency'] = 'ريال';
$string['days'] = 'أيام';
$string['hours'] = 'ساعات';
$string['minutes'] = 'دقائق';
$string['seconds'] = 'ثواني';
$string['username'] = 'اسم المستخدم';
$string['password'] = 'كلمة المرور';
$string['notifications'] = 'التنبيهات';
$string['item'] = 'عنصر';
$string['your_order'] = 'شكرا لطلبك.';
$string['payment_method'] = 'طرق الدفع:';
$string['receipt'] = 'إيصال';
$string['date'] = 'التسجيل يبدأ';
$string['status'] = 'الحالة';
$string['total'] = 'الكل';
$string['total_courses'] = 'الدورات';
$string['price'] = 'السعر';
$string['course_id'] = 'معرف الدورة';
$string['action'] = 'إجراء';
$string['customer_id'] = 'معرف العميل';
$string['customer_username'] = 'اسم العميل';
$string['customer_email'] = 'البريد الإلكتروني للعميل';
$string['completed'] = 'مدفوع';
$string['currency_symbol'] = 'ريال';
$string['currency'] = 'ريال';
$string['your_profile_views'] = 'مشاهدات ملفك الشخصي';
$string['profile_views'] = 'مشاهدات الملف الشخصي';
$string['your_profile_views_long'] = 'نظرة عامة على زيارات ملفك الشخصي خلال الأسبوع الماضي';
$string['your_profile_views_dataset'] = 'زيارات';
$string['instructors'] = 'مدربين';
$string['last_online'] = 'اخر تواجد أونلاين';
$string['comments'] = 'تعليقات';
$string['reviews'] = 'مراجعات';
$string['preview_course'] = 'استعراض الدورة التدريبية';
$string['library'] = 'المكتبة';
$string['have_an_account'] = 'تمتلك حساب?';
$string['course_content'] = 'محتوى الدورة التدريبية';
$string['end_date'] = 'تاريخ الانتهاء';
$string['view'] = 'مشاهدة';
$string['published'] = 'تم النشر';
$string['apostrophe_s'] = '\'s';
$string['stars_5'] = 'نجوم 5';
$string['stars_4'] = 'نجوم 4';
$string['stars_3'] = 'نجوم 3';
$string['stars_2'] = 'نجوم 2';
$string['stars_1'] = 'نجوم 1';
$string['rated_by_none'] = 'لم يتم التقييم بعد';
$string['add_comment'] = 'أضف تعليقًا ومراجعة';
$string['speaks'] = 'يتحدث:';
$string['scroll_down'] = 'مرر لأسفل';
$string['to_discover_more'] = 'لاكتشاف المزيد';
$string['ccn_cf_free'] = 'مجانا';
$string['ccn_cf_paid'] = 'دفع';
$string['ccn_cf_5_stars'] = '5 نجوم وما فوق';
$string['ccn_cf_4_stars'] = '4 نجوم وما فوق';
$string['ccn_cf_3_stars'] = '3 نجوم وما فوق';
$string['ccn_cf_2_stars'] = '2 نجوم وما فوق';
$string['ccn_cf_1_stars'] = '1 نجوم وما فوق';
$string['ccn_cf_show_all'] = 'عرض الكل';
$string['ccn_cf_all_matching'] = 'كل المطابقة';
$string['no_students_yet'] = 'لا يوجد طلاب حتى الآن';
$string['no_courses_yet'] = 'لا توجد دورات بعد';
$string['interested_in'] = 'الإهتمامات';
