<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'ar', version '3.10'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'القبول';
$string['accept_grades'] = 'قبول العلامات من الأداة';
$string['accept_grades_admin'] = 'قبول العلامات من الأداة';
$string['accept_grades_admin_help'] = 'تحديد ما إذا كان مزود الأداة يمكن أن يضيف، يحدّث، يقرأ، ويحذف التقديرات المرتبطة مع عينات هذه الأداة.

بعض مزودي الأداة يدعمون الإبلاغ عن التقديرات إلى مودل بناءً على الإجراءات المتخذة في الأداة، مما يخلق تجربة أكثر تكاملاً.';
$string['accept_grades_help'] = 'تحديد ما إذا كان مزود الأداة يمكن أن يضيف، يحدّث، يقرأ، ويحذف التقديرات المرتبطة مع عينات هذه الأداة.

بعض مزودي الأداة يدعمون الإبلاغ عن التقديرات إلى مودل بناءً على الإجراءات المتخذة في الأداة، مما يخلق تجربة أكثر تكاملاً.

لاحظ أن هذا الإعداد يمكن تجاوزه في تهيئة الأداة.';
$string['accepted'] = 'تم قبولها';
$string['action'] = 'الإجراء';
$string['activate'] = 'تنشيط';
$string['activatetoadddescription'] = 'ستحتاج إلى تنشيط هذه الأداة قبل أن تتمكن من إضافة وصف.';
$string['active'] = 'نشط';
$string['activity'] = 'نشاط';
$string['add_ltiadv'] = 'إضافة فائدة لأداة التعلم التوافقية';
$string['add_ltilegacy'] = 'إضافة أداة التعلم التوافقية (قديمة)';
$string['addnewapp'] = 'مكّن التطبيق الخارجي';
$string['addserver'] = 'إضافة مخدم موثوق به جديد';
$string['addtype'] = 'إضافة أداة مسبقة التهيئة';
$string['allow'] = 'إسمح';
$string['allowsetting'] = 'اسمح للأداة بتخزين 8K من الإعدادات في  مودل';
$string['always'] = 'دائما';
$string['autoaddtype'] = 'أضف أداة';
$string['automatic'] = 'تلقائياً، استناداً إلى رابط الأداة';
$string['baseurl'] = 'قاعدة الرابط / الأداة اسم التسجيل';
$string['basiclti'] = 'أدوات التعلم المشتركة';
$string['basiclti_base_string'] = 'مقاطع أدوات التعلم المشتركة OAuth';
$string['basiclti_endpoint'] = 'أدوات التعلم المشتركة تطلق نقطة الانتهاء';
$string['basiclti_in_new_window'] = 'قد افتتح نشاطك في نافذة جديدة';
$string['basiclti_in_new_window_open'] = 'فتح في نافذة جديدة';
$string['basiclti_parameters'] = 'إطلاق معاملات أدوات التعلم المشتركة';
$string['basicltiactivities'] = 'أنشطة  أدوات التعلم المشتركة';
$string['basicltifieldset'] = 'مثال مخصص لمجموعة الحقول';
$string['basicltiintro'] = 'وصف النشاط';
$string['basicltiname'] = 'اسم النشاط';
$string['basicltisettings'] = 'إعدادات (LTI)  أدوات التعلم المشتركة';
$string['cachedef_keyset'] = 'يحفظ نسخة مخبأة من معلومات مجموعة مفاتيح للأدوات';
$string['cancel'] = 'إلغاء';
$string['cancelled'] = 'ألغيت';
$string['cannot_delete'] = 'لا تستطيع حذف تكوين هذه الأداة.';
$string['cannot_edit'] = 'لا تستطيع تحرير تكوين هذه الأداة.';
$string['capabilities'] = 'الإمكانيات';
$string['capabilities_help'] = 'حدد تلك الإمكانيات التي ترغب بتقديمها لمزود الأداة. يمكن اختيار أكثر من إمكانية.';
$string['capabilitiesrequired'] = 'تتطلب هذه الأداة الوصول إلى البيانات التالية من أجل التنشيط:';
$string['cleanaccesstokens'] = 'إزالة الأداة الخارجية لترميزات الوصول منتهية الصلاحية';
$string['click_to_continue'] = 'انقر للمتابعة';
$string['clientidadmin'] = 'معرف العميل';
$string['clientidadmin_help'] = 'يمكن اعتبار مُعرَّف العميل كقيمة فريدة تستعمل للتعرف على الأداة. يتم إنشاؤه تلقائياً لكل أداة تستعمل ملف تعريف أمان JWT المقدم في LTI 1.3 وينبغي أن يكون جزءاً من التفاصيل التي تم تمريرها إلى مزود الأداة حتى يتمكنوا من تهيئة الاتصال من طرفهم.';
$string['comment'] = 'تعليق';
$string['configpassword'] = 'كلمة المرور الافتراضية لأداة عن بعد';
$string['configpreferheight'] = 'الارتفاع الافتراضي المفضل';
$string['configpreferwidget'] = 'تعيين الأداة  كإطلاق افتراضي';
$string['configpreferwidth'] = 'العرض الافتراضي المفضل';
$string['configresourceurl'] = 'ربط المصدر الافتراضي';
$string['configtoolurl'] = 'رابط الأداة الافتراضي عن بعد';
$string['configtypes'] = 'مكّن تطبيقات أدوات التعلم المشتركة';
$string['configured'] = 'تكوين';
$string['confirmtoolactivation'] = 'هل أنت متأكد من رغبتك في تنشيط هذه الأداة؟';
$string['contentitem'] = 'رسالة محتوى العنصر';
$string['contentitem_deeplinking'] = 'يدعم الربط العميق (رسالة عنصر المحتوى)';
$string['contentitem_deeplinking_help'] = 'إذا تم تأشيره، فسيكون خيار \'اختيار المحتوى\' متاحاً عند إضافة أداة خارجية.';
$string['contentitem_help'] = 'إذا تم تأشيره، فسيكون خيار \'اختيار المحتوى\' متاحاً عند إضافة أداة خارجية.';
$string['contentitem_multiple_description'] = 'العناصر الآتية ستتم إضافتها إلى مقررك:';
$string['contentitem_multiple_graded'] = 'نشاط سبق منحه علامات (العلامة القصوى: {$a})';
$string['course_tool_types'] = 'أدوات المقرر';
$string['courseactivitiesorresources'] = 'أنشطة المقرر الدراسي أو موارده';
$string['courseid'] = 'رقم مُعرَّف المساق';
$string['courseinformation'] = 'معلومات المقرر الدراسي';
$string['courselink'] = 'إذهب إلى المقرر';
$string['coursemisconf'] = 'تهيئة خاطئة للمقرر';
$string['createdon'] = 'تم إنشاؤه في';
$string['curllibrarymissing'] = 'مكتبة PHP Curl يجب أن تكون مثبتة عند استخدام أدوات التعلم المشتركة';
$string['custom'] = 'معاملات مخصصة';
$string['custom_config'] = 'استخدام إعدادات الأداة مخصصة';
$string['custom_help'] = 'العوامل المخصصة هي إعدادات يستعملها مزود الأداة. على سبيل المثال، يمكن استخدام معامل مخصص لعرض مورد معين من المزود. يجب إدخال كل معامل في سطر منفصل باستعمال تنسيق "الاسم=القيمة"؛ على سبيل المثال، "chapter=3".

من الآمن ترك هذا الحقل بدون تغيير ما لم يصدر بذلك توجيه من مزود الأداة.';
$string['custominstr'] = 'معطيات مخصصة';
$string['debuglaunch'] = 'خيار التصحيح';
$string['debuglaunchoff'] = 'إطلاق عادي';
$string['debuglaunchon'] = 'إطلاق تصحيح الأخطاء';
$string['default'] = 'الافتراضي';
$string['default_launch_container'] = 'حاوية الإطلاق الافتراضية';
$string['default_launch_container_help'] = 'حاوية الإطلاق تؤثر على عرض الأداة عندما تطلق من المقرر. بعض حاويات الإطلاق توفر مساحة شاشة أكبر لهذه الأداة، وغيرها توفر شعورًا أكثر تكاملاً مع بيئة مودل.

* **افتراضي** - استعمال حاوية الإطلاق التي تحددها تهئية الأداة.
* **تضمين** - يتم عرض الأداة ضمن إطار مودل الموجود، بطريقة مشابهة لمعظم أنواع النشاطات الأخرى.
* **إدراج، بدون كتل** - يتم عرض الأداة ضمن إطار مودل الموجود، بمجرد عناصر التنقل في الجزء العلوي من الصفحة.
* **نافذة جديد** - تفتح الأداة في نافذة جديدة، وتحتل كل المساحة المتاحة. اعتمادًا على المتصفح، سيتم فتحها في تبويب جديدة أو نافذة منبثقة جديدة. من الممكن للمتصفحات أن تمنع نافذة جديدة من الانبثاق.';
$string['delegate'] = 'تفويض المعلم';
$string['delegate_tool'] = 'كما هو محدد في تعريف الربط العميق أو التفويض للمعلم';
$string['delete'] = 'احذف';
$string['delete_confirmation'] = 'هل أنت متأكد أنك تريد حذف تكوين هذه الأداة الخارجية؟';
$string['deletetype'] = 'هل تريد بالتأكيد حذف هذه الأداة المُعدة مسبقًا؟';
$string['display_description'] = 'عرض وصف النشاط عند إطلاقه';
$string['display_description_help'] = 'إذا اخترتها، فإن وصف النشاط (المحدد أعلاه) سُيعرض أعلى محتوى مزود الأداة.

يمكن استعمال الوصف لتقديم إرشادات إضافية لمطلقي الأداة، ولكن ليس ذلك مطلوبا.

لن يتم عرض الوصف أبدًا عند إطلاق حاوية الأداة في نافذة جديدة.';
$string['display_name'] = 'عرض اسم النشاط عند إطلاقه';
$string['display_name_help'] = 'إذا اخترتها، فإن اسم النشاط (المحدد أعلاه) سيُعرض أعلى محتوى مزود الأداة.

من الممكن أن مزود الأداة يعرض العنوان أيضاً. هذا الخيار يمكنه منع عرض عنوان النشاط مرتين.

لن يتم عرض عنوان الأداة أبداً عندما تكون حاوية إطلاقها نافذة جديدة.';
$string['domain_mismatch'] = 'نطاق رابط الأداة لا يتطابق مع تكوين الأداة .';
$string['donot'] = 'لا ترسل';
$string['donotaccept'] = 'لا تقبل';
$string['donotallow'] = 'لا تسمح';
$string['duplicateregurl'] = 'رابط التسجيل هذا قيد الاستخدام بالفعل';
$string['editdescription'] = 'أنقر هنا لإعطاء هذه الأداة وصفاً';
$string['edittype'] = 'تحرير أداة مسبقة التهيئة';
$string['embed'] = 'ضمّن';
$string['embed_no_blocks'] = 'ضمّن، بدون الكتل';
$string['enableemailnotification'] = 'إرسال إخطار برسائل بريد إلكتروني';
$string['enableemailnotification_help'] = 'في حالة التمكين ، سيتلقى الطلاب إشعارًا بالبريد الإلكتروني عند تقدير الأداة عمليات إرسالتهم.';
$string['enterkeyandsecret'] = 'أدخل مفتاح المستفيد والسر المشترك';
$string['enterkeyandsecret_help'] = 'إذا تم منحك مفتاح المستفيد و/أو السر المشترك، فأدخلهما هنا';
$string['errorbadurl'] = 'الرابط ليس أداة صحيحة أو مُرّكبة صالحة.';
$string['errorincorrectconsumerkey'] = 'مفتاح المستفيد غير صحيح.';
$string['errorinvaliddata'] = 'بيانات غير صالحة: {$a}';
$string['errorinvalidmediatype'] = 'نوع الوسائط غير صالح: {$a}';
$string['errorinvalidresponseformat'] = 'تنسيق استجابة محتوى عنصر غير صالح.';
$string['errormisconfig'] = 'تهيئة خاطئة للأداة.
يرجى مطالبة مسؤول مودل لإصلاح تكوين الأداة.';
$string['errortooltypenotfound'] = 'لم يتم العثور على نوع أداة التعلم المشترك.';
$string['existing_window'] = 'النافذة الموجودة';
$string['extensions'] = 'تمديد خدمات أدوات التعلم المشتركة';
$string['external_tool_type'] = 'أداة مسبقة التهيئة';
$string['external_tool_type_help'] = '* **تلقائي، بناءً على رابط الأداة** - يتم اختيار أفضل تهيئة للأداة تلقائياً. إذا لم يتم التعرف على رابط الأداة، فقد تكون هناك حاجة لإدخال تفاصيل تهيئة الأداة يدوياً.
* **أداة محددة مسبقة التهيئة** - سيتم استعمال التهيئة للأداة المحددة عند الاتصال بمزود الأداة الخارجية. إذا لم يبدُ على رابط الأداة أنه ينتمي إلى مزودها، فسيتم إظهار تحذير. ليس من الضروري دائماً إدخال رابط للأداة.
* **التهيئة المخصصة** - قد تكون هناك حاجة لإدخال مفتاح المستفيد وسر المشاركة يدوياً. يمكن الحصول على مفتاح المستفيد وسر المشاركة من مزود الأداة. مع ذلك، لا تتطلب جميع الأدوات مفتاح عميل وسر مشاركة، وفي هذه الحالة قد تترك الحقول فارغة.

 ### تحرير الأداة المُسبقة التهيئة

تتوفر ثلاث أيقونات بعد القائمة المنسدلة للأداة المسبقة التهيئة:

* **إضافة** - إنشاء تهيئة الأداة على مستوى المقرر الدراسي. قد تستعمل كل عيِّنات الأداة الخارجية في هذا المقرر تلك التهيئة.
* **تحرير** - حدد أداةً على مستوى المقرر الدراسي من القائمة المنسدلة، ثم انقر على هذه الأيقونة. يمكن تحرير تفاصيل تهيئة الأداة.
* **حذف** - إزالة أداة مستوى المقرر المحددة.';
$string['external_tool_types'] = 'الأدوات مسبقة التهيئة';
$string['failedtoconnect'] = 'مودل غير قادر على الاتصال مع نظام  {$a}';
$string['failedtocreatetooltype'] = 'فشل في إنشاء أداة جديدة. يرجى التحقق من الرابط  والمحاولة مرة أخرى.';
$string['failedtodeletetoolproxy'] = 'فشل في حذف تسجيل الأداة. قد تحتاج إلى زيارة "إدارة تسجيلات الأدوات الخارجية" وحذفها يدويًا.';
$string['filter_basiclti_configlink'] = 'تهيئة مواقعك المفضلة وكلمات المرور الخاصة بها';
$string['filter_basiclti_password'] = 'كلمة المرور إلزامية';
$string['filterconfig'] = 'إدارة أدوات التعلم المشتركة';
$string['filtername'] = 'أدوات التعلم المشتركة';
$string['fixexistingconf'] = 'استخدم الإعدادات المسبقة للأداة المهيئة بشكل خاطئ';
$string['fixnew'] = 'الإعدادات الجديدة';
$string['fixnewconf'] = 'عرّف إعدادات جديدة للنموذج المعد بشكل خاطئ';
$string['fixold'] = 'استخدام الموجود';
$string['force_ssl'] = 'فرض طبقة المنافذ الآمنة';
$string['force_ssl_help'] = 'اختيار هذا الخيار يفرض جميع عمليات الإطلاق لهذه الأداة لاستخدام مزود  طبقة المنافذ الآمنة. بالإضافة إلى ذلك، فإن جميع طلبات الخدمة من مزود الويب للأداة يستخدم  طبقة المنافذ الآمنة.
في حالة استخدام هذا الخيار، تأكد أن مودل هذا يدعم مزود الخدمة للأداة  طبقة المنافذ الآمنة .';
$string['forced_help'] = 'هذا الإعداد إجباري في المقرر أو  تكوين الأداة على مستوى الموقع . لا تستطيع تغييره من هذه الواجهة.';
$string['generaltool'] = 'أداة عامة';
$string['global_tool_types'] = 'الأدوات مسبقة التهيئة';
$string['grading'] = 'توجيه العلامات';
$string['icon_url'] = 'أيقونة الرابط';
$string['icon_url_help'] = 'رابط الأيقونة يسمح للرمز الذي يظهر في قائمة المقرر لهذا النشاط بالتعديل. بدلا من  استخدام أيقونة أدوات التعلم المشترك، الأيقونة الافتراضية هي الأيقونة التي تحمل التعبير عن نوع  النشاط الذي يمكن تحديده.';
$string['id'] = 'رقم التعريف';
$string['indicator:cognitivedepth'] = 'أدوات التعلم التوافقية معرفياً';
$string['indicator:cognitivedepth_help'] = 'يعتمد هذا المؤشر على العمق المعرفي الذي وصل إليه الطالب في نشاط أدوات التعلم المشتركة.';
$string['indicator:cognitivedepthdef'] = 'أدوات التعلم التوافقية معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات أدوات التعلم التوافقية خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم، معاينة الرد)';
$string['indicator:socialbreadth'] = 'أدوات التعلم التوافقية إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط أدوات التعلم المشتركة.';
$string['indicator:socialbreadthdef'] = 'أدوات التعلم التوافقية إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات أدوات التعلم التوافقية خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً، المشاركة مع الآخرين)';
$string['initiatelogin'] = 'رابط تسجيل الدخول المبدئ';
$string['initiatelogin_help'] = 'رابط الأداة الذي سيتم إرسال طلبات بدء تسجيل الدخول إليه.
مطلوب هذا رابط قبل إرسال رسالة النجاح إلى الأداة.';
$string['invalidid'] = 'رقم تعريف أدوات التعلم المشترك غير صحيح';
$string['jwtsecurity'] = 'أدوات التعلم المشتركة  1.3';
$string['keytype'] = 'نوع المفتاح العام';
$string['keytype_help'] = 'طريقة المصادقة المستعملة للتحقق من الأداة.';
$string['keytype_keyset'] = 'رابط مجموعة المفاتيح';
$string['keytype_rsa'] = 'مفتاح RSA';
$string['launch_in_moodle'] = 'إطلاق الأداة في مودل';
$string['launch_in_popup'] = 'إطلاق الأداة في نافذة منبثقة';
$string['launch_url'] = 'رابط الأدارة';
$string['launch_url_help'] = 'يشير عنوان رابط الأداة إلى عنوان الويب للأداة الخارجية، وقد يحتوي على معلومات إضافية، مثل الموارد المزمع إظهارها.
إذا كنت غير متأكد مما عليك إدخاله كرابط للأداة، لطفاً، تحقق من مزود الأداة لمزيد من المعلومات.

يمكنك إدخال رابط الخرطوش إذا كان متاحاً لك، وباقي تفاصيل النموذج ستتم تعبئتها تلقائياً.

إذا قمت باختيار أداة مسبقة التهيئة، فقد لا تحتاج إلى إدخال رابط الأداة. إذا كان رابط الأداة مستعملاً لمجرد الإطلاق في نظام مزود الأداة، وليس الذهاب إلى مورد معين، فهذا عادة ما يكون هو الحال.';
$string['launchinpopup'] = 'حاوية الإطلاق';
$string['launchinpopup_help'] = 'حاوية الإطلاق تؤثر على عرض الأداة عندما تطلق من المقرر. بعض حاويات الإطلاق توفر مساحة شاشة أكبر لهذه الأداة، وغيرها توفر شعورًا أكثر تكاملاً مع بيئة مودل.

* **افتراضي** - استعمال حاوية الإطلاق التي تحددها تهئية الأداة.
* **تضمين** - يتم عرض الأداة ضمن إطار مودل الموجود، بطريقة مشابهة لمعظم أنواع النشاطات الأخرى.
* **إدراج، بدون كتل** - يتم عرض الأداة ضمن إطار مودل الموجود، بمجرد عناصر التنقل في الجزء العلوي من الصفحة.
* **نافذة جديد** - تفتح الأداة في نافذة جديدة، وتحتل كل المساحة المتاحة. اعتمادًا على المتصفح، سيتم فتحها في تبويب جديدة أو نافذة منبثقة جديدة. من الممكن للمتصفحات أن تمنع نافذة جديدة من الانبثاق.';
$string['launchoptions'] = 'خيارات الإطلاق';
$string['leaveblank'] = 'أتركه فارغاً إذا كنت لا تحتاج إليه';
$string['lti'] = 'أدوات التعلم المشتركة';
$string['lti:addcoursetool'] = 'إضافة تهيئات أداة خاصة بالمقرر الدراسي';
$string['lti:addinstance'] = 'إضافة أداة خارجية جديدة';
$string['lti:addmanualinstance'] = 'إضافة أداة مهيئة يدوياً';
$string['lti:addpreconfiguredinstance'] = 'إضافة أداة مسبقة التهيئة';
$string['lti:admin'] = 'أن يكون مشرفاً عند إطلاق الأداة';
$string['lti:grade'] = 'معاينة العلامات المسترجعة من الأدارة الخارجية';
$string['lti:manage'] = 'أن يكون مرشداً عندما يتم إطلاق الأداة';
$string['lti:requesttooladd'] = 'طلب تهيئة أداة على مستوى الموقع';
$string['lti:view'] = 'إطلاق أنشطة أدوات التعلم الخارجية';
$string['lti_administration'] = 'تحرير الأداة مسبقة التهيئة';
$string['lti_errormsg'] = 'الأداة أظهرت رسالة الخطأ التالية  "{$a}"';
$string['lti_launch_error'] = 'حدث خطأ عند إطلاق الأداة الخارجية:';
$string['lti_launch_error_tool_request'] = '<p> لتقديم طلب للمسؤول لاستكمال تكوين الأداة، انقر فوق <a href="{$a->admin_request_url}" target="_top">هنا</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p> قد يكون هذا الخطأ نتيجة فقد اسم المستخدم أو كلمة المرور لموفر الأداة. </ P>
<p> إذا كان لديك اسم المستخدم أو كلمة المرور، فأدخله عند تحرير مثال الأداة خارجية (تأكد من أن الخيارات المتقدمة مرئية).
<br /> بدلاً من ذلك، يمكنك إنشاء تكوين على مستوى المقرر لمزود الأداة <a href="{$a->course_tool_editor}">here</a>. </p>';
$string['lti_tool_request_added'] = 'طلب تكوين الأداة قدم بنجاح.
قد تحتاج إلى الاتصال بالمسؤول لاستكمال تكوين الأداة .';
$string['lti_tool_request_existing'] = 'تم إرسال تكوين أداة لنطاق الأداة بالفعل.';
$string['ltisettings'] = 'إعدادات أدوات التعلم المشتركة';
$string['ltiunknownserviceapicall'] = 'أدوات التعلم المشتركة لم تتعرف على خدمة API .';
$string['ltiversion'] = 'نسخة أدوات التعلم المشتركة';
$string['ltiversion_help'] = 'إصدار LTI الجاري استخدامه لتوقيع الرسائل وطلبات الخدمة: يستخدم LTI 1.0 / 1.1 و LTI 2.0 ملف تعريف أمان OAuth 1.0A ؛ يستخدم LTI 1.3.0 JWTs.';
$string['main_admin'] = 'تعليمات عامة';
$string['main_admin_help'] = 'الأدوات الخارجية تسمح لمستخدمي مودل بالتفاعل بسلاسة مع موارد التعلم المستضافة عن بعد. من خلال بروتوكول إطلاق خاص، سيكون للأداة وصول لمعلومات عامة عن المستخدم الذي قام بالإطلاق. على سبيل المثال، اسم المؤسسة، مُعرَّف المقرر الدراسي، مُعرَّف المستخدم، وغيرها من المعلومات مثل اسم المستخدم أو عنوان بريده الالكتروني.

الأدوات المدرجة في هذه الصفحة يتم فصلها إلى ثلاث فئات:

* **نشطة** - مقدمو هذه الأداة تمت الموافقة عليهم وتكوينها من قبل المشرف. يمكن استعمالها من داخل أي مقرر في هذا الموقع. إذا تم إدخال مفتاح المستهلك وكلمة المرور المشتركة، يتم تأسيس علاقة ثقة بين هذا الموقع من مودل والأداة البعيدة، مما يوفر قناة اتصال آمن.
* **معلقة** - مزودو هذه الأداة جاؤوا من خلال استيراد حزمة، ولكن لم يتم تهيئتها من قبل المشرف. المعلمون قد يستعملوا أدوات من هؤلاء المزودين إذا كان لديهم مفتاح المستهلك وكلمة المرور المشتركة، أو إذا لم يكن أي منهما مطلوباً.
* **مرفوضة** - مزودو هذه الأدوات تم تأشيرهم بأنهم أولئك الذين ليست في نية المشرف إتاحتهم في الموقع. المعلمون قد يستعملوا أدوات من هؤلاء المزودين إذا كان لديهم مفتاح المستهلك وكلمة المرور المشتركة، أو إذا لم يكن أي منهما مطلوباً.';
$string['manage_external_tools'] = 'إدارة الأدوات';
$string['manage_tool_proxies'] = 'إدارة تسجيلات الأداة الخارجية';
$string['manage_tools'] = 'إدارة الأدوات المعدة مسبقًا';
$string['manuallyaddtype'] = 'بدلاً من ذلك، يمكنك <a href="{$a}">تهيئة الأداة يدوياً</a>.';
$string['miscellaneous'] = 'متنوع';
$string['misconfiguredtools'] = 'تم الكشف عن حالات الأداة بالتهيئة الخاطئة';
$string['missingparameterserror'] = 'الصفحة لم  يتم تكوينها بشكل صحيح: "{$a}"';
$string['module_class_type'] = 'نوع الوحدة النمطية لمودل';
$string['modulename'] = 'أداة خارجية';
$string['modulename_help'] = 'وحدة نشاط الأداة الخارجية تمكن الطلاب من التفاعل مع مصارد وأنشطة التعلم في مواقع الإنترنت الأخرى. على سبيل المثال، يمكن للأداة الخارجية توفير الوصول إلى نوع نشاط جديد أو مواد تعليمية من ناشر ما.

لإنشاء نشاط أداة خارجية، يتطلب الأمر وجود مزود الأداة التي تدعم LTI (أدوات التعلم المشتركة). يمكن للمعلم إنشاء نشاط أداة خارجية أو الاستفادة من أداة تمت تهيئتها من قبل المسؤول عن الموقع.

تختلف أنشطة الأداة الخارجية عن موارد عنوان الرابط في القليل من الطرق:

* الأدوات الخارجية مدركة للسياق، أي لديها وصول إلى معلومات عن المستخدم الذي أطلق الأداة، كالمؤسسة، المقرر والاسم.
* الأدوات الخارجية تدعم قراءة، تحديث وحذف التقديرات المرتبطة بعينة النشاط.
* تهيئات الأداة الخارجية تنشئ علاقة ثقة بين موقعك ومزود الأداة، مما يسمح بالاتصال الآمن بينهما.';
$string['modulenameplural'] = 'أدوات خارجية';
$string['modulenamepluralformatted'] = 'عيِّنات أدوات التعلم التوافقية';
$string['name'] = 'الاسم';
$string['never'] = 'أبدأ';
$string['new_window'] = 'نافذة جديدة';
$string['no_lti_configured'] = 'لا توجد أدوات خارجية نشطة معدّة.';
$string['no_lti_pending'] = 'لا توجد أدوات خارجية بحالة انتظار.';
$string['no_lti_rejected'] = 'لا توجد أدوات خارجية رفضت.';
$string['no_lti_tools'] = 'لا توجد أدوات خارجية مكوّنة.';
$string['no_tp_accepted'] = 'لا توجد تسجيلات أداة خارجية مقبولة.';
$string['no_tp_cancelled'] = 'لا توجد تسجيلات للأدوات الخارجية ملغاة.';
$string['no_tp_configured'] = 'لا توجد تسجيلات لأدوات خارجية غير مسجلة مكونة.';
$string['no_tp_pending'] = 'لا توجد تسجيلات أداة خارجية معلقة.';
$string['no_tp_rejected'] = 'لا توجد تسجيلات أداة خارجية مرفوضة.';
$string['noattempts'] = 'لم تجري محاولات على أداة مثيلة';
$string['noltis'] = 'لا توجد أدوات خارجية مثيلة';
$string['noprofileservice'] = 'لم يتم العثور على خدمة الملف الشخصي';
$string['noservers'] = 'لم يتم العثور على خادم';
$string['notypes'] = 'لا يوجد حاليا أيّ إعداد لأدوات التعلم المشتركة في مودل. أنقر على رابط التنصيب أعلاه لإضافة بعضها.';
$string['noviewusers'] = 'لم يتم العثور على المستخدمين مع أذونات الاستخدام هذه الأداة';
$string['oauthsecurity'] = 'أدوات التعلم المشتركة 1.0 / 1.1';
$string['opensslconfiginvalid'] = 'تتطلب أدوات التعلم المشتركة 1.3 وجود opensl.cnf صالحة، مهيأة ومتاحة لمخدم الويب الخاص بك. يرجى الاتصال بمشرف الموقع لتكوين وتمكين openssl فيه.';
$string['optionalsettings'] = 'إعدادات اختيارية';
$string['organization'] = 'تفاصيل المنظمة';
$string['organizationdescr'] = 'وصف المنظمة';
$string['organizationid'] = 'مُعرَّف المنظمة';
$string['organizationid_default'] = 'مُعرَّف المنظمة الافتراضي';
$string['organizationid_default_help'] = 'القيمة الافتراضية المستعملة لمُعرَّف المنظمة. مُعرَّف الموقع يمثل هذا التنصيب من مودل.';
$string['organizationid_help'] = 'معرف فريد لهذا التنصيب من لمودل. عادة ما يتم استعمال اسم DNS للمنظمة.

إذا تم ترك هذا الحقل فارغاً، سيتم استعمال اسم المضيف لموقع مودل هذا كقيمة إفتراضية.';
$string['organizationidguid'] = 'مُعرَّف المنظمة';
$string['organizationidguid_help'] = 'مُعرَّف فريد لهذه العينة من مودل يتم تمريرها إلى الأداة بمثابة المُعرَّف الفريد العالمي لعينة المنصة.

إذا تم ترك الحقل فارغاً، سيتم استعمال القيمة الافتراضية.';
$string['organizationurl'] = 'عنوان رابط المنظمة';
$string['organizationurl_help'] = 'الرابط الأساسي المثيل لمودل . إذا تركت هذا الحقل فارغاً، سيتم استخدام قيمة افتراضية استناداً إلى إعدادات الموقع .';
$string['pagesize'] = 'التسليمات المعروضة لكل صفحة';
$string['parameter'] = 'معلّمات الأداة';
$string['parameter_help'] = 'معلّمات الأداة هي الإعدادات المطلوبة لتمريرها بواسطة موفر الأداة في وكيل الأداة المقبولة.';
$string['password'] = 'السر المشترك';
$string['password_admin'] = 'السر المشترك';
$string['password_admin_help'] = 'يمكن اعتبار السر المشترك ككلمة المرور المستعملة لمصادقة الوصول إلى الأداة . ينبغي توفيرها جنباً إلى جنب مع مفتاح المستفيد من مزود الأداة.

الأدوات التي لا تتطلب اتصال آمن من مودل، ولا توفر خدمات إضافية (مثل تقارير التقديرات) قد لا تتطلب سرًا مشتركًا.';
$string['password_help'] = 'للأدوات التي تمت تهيئتها مسبقًا، فإنه ليس من الضروري إدخال السر المشترك هنا، نظرًا لأنه سيتم توفيره كجزء من عملية التهيئة.

يجب إدخال هذا الحقل إذا أنشئ رابط إلى مزود الأداة التي لم تتم تهيئتها بالفعل.
إذا كان مزود الأداة سيستعمل أكثر من مرة في هذا المقرر، فتهيئة الأداة على مستوى المقرر فكرة جيدة.

السر المشترك يمكن النظر إليه بمثابة كلمة المرور لمصادقة الوصول إلى الأداة. ينبغي توفيره جنباً إلى جنب مع مفتاح المستفيد من مزود الأداة.

الأدوات التي لا تتطلب اتصال آمن من مودل ولا توفر خدمات إضافية (مثل تقارير التقديرات) قد لا تتطلب سرًا مشتركًا.';
$string['pending'] = 'معلّق';
$string['pluginadministration'] = 'إدارة الأدوات الخارجية';
$string['pluginname'] = 'الأدوات الخارجية';
$string['preferheight'] = 'الارتفاع المفضل';
$string['preferwidget'] = 'تفضيلات إطلاق القطعة';
$string['preferwidth'] = 'العرض المفضل';
$string['press_to_submit'] = 'اضغط لتشغيل هذا النشاط';
$string['privacy'] = 'الخصوصية';
$string['privacy:metadata:coursefullname'] = 'الاسم الكامل للمقرر الذي يقوم المستخدم بالوصول إليه كعميل أداة التعلم المشترك';
$string['privacy:metadata:courseid'] = 'مُعرَّف المقرر الدراسي الذي يقوم المستخدم بالوصول إليه من عميل أداة التعلم المشترك';
$string['privacy:metadata:courseidnumber'] = 'رقم مُعرَّف المساق الذي يقوم المستخدم بالوصول إليه كعميل أداة التعلم المشترك';
$string['privacy:metadata:courseshortname'] = 'الاسم المختصر للمقرر والذي يقوم المستخدم بالوصول إليه كعميل مواد تعلم مشترك';
$string['privacy:metadata:createdby'] = 'المستخدم الذي أنشأ السجل';
$string['privacy:metadata:email'] = 'عنوان البريد الإلكتروني للمستخدم الذي يصل إلى أداة التعلم المشترك كعميل';
$string['privacy:metadata:externalpurpose'] = 'يوفر المستفيد من أداة التعلم المشترك معلومات المستخدم والسياق إلى مزود أداة التعلم المشترك';
$string['privacy:metadata:firstname'] = 'الاسم الأول للمستخدم الذي يصل إلى مستفيد من أداة التعلم المشترك';
$string['privacy:metadata:fullname'] = 'الاسم الكامل للمستخدم الذي يصل إلى مستفيد من أداة التعلم المشترك';
$string['privacy:metadata:lastname'] = 'اسم العائلة للمستخدم الذي يصل مستفيد من أداة التعلم المشترك';
$string['privacy:metadata:lti_submission'] = 'تقديم المستفيد من أداة التعلم المشترك';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'الطابع الزمني الذي يشير إلى وقت التقديم';
$string['privacy:metadata:lti_submission:dateupdated'] = 'الطابع الزمني الذي يشير إلى وقت تعديل التقديم';
$string['privacy:metadata:lti_submission:gradepercent'] = 'التقدير للمستخدم كنسبة مئوية';
$string['privacy:metadata:lti_submission:originalgrade'] = 'العلامات الأصلية للمستخدم';
$string['privacy:metadata:lti_submission:userid'] = 'معرف المستخدم الذي أرسل النشاط لأداة التعلم المشترك';
$string['privacy:metadata:lti_tool_proxies'] = 'وكلاء أداة التعلم المشترك';
$string['privacy:metadata:lti_tool_proxies:name'] = 'اسم الوكيل أداة التعلم المشترك';
$string['privacy:metadata:lti_types'] = 'أنواع أداة التعلم المشترك';
$string['privacy:metadata:lti_types:name'] = 'اسم نوع أداة التعلم المشترك';
$string['privacy:metadata:role'] = 'الدور في المقرر الدراسي للمستخدم الذي يصل كمستفيد أداة التعلم المشترك';
$string['privacy:metadata:timecreated'] = 'الوقت الذي تم فيه إنشاء السجل';
$string['privacy:metadata:timemodified'] = 'الوقت الذي تم فيه تعديل السجل';
$string['privacy:metadata:userid'] = 'معرف المستخدم الذي يصل إلى مستفيد أداة التعلم المشترك';
$string['privacy:metadata:useridnumber'] = 'رقم معرّف المستخدم الذي يصل إلى مستفيد أداة التعلم المشترك';
$string['privacy:metadata:username'] = 'اسم المستخدم للمستخدم الذي يصل إلى مستفيد أداة التعلم المشترك';
$string['publickey'] = 'المفتاح العمومي';
$string['publickey_help'] = 'المفتاح العمومي (بتنسيق PEM) الذي توفره الأداة للسماح بالتحقق من توقيعات الرسائل الواردة وطلبات الخدمة.';
$string['publickeyset'] = 'مجموعة المفاتيح العامة';
$string['publickeyset_help'] = 'مجموعة المفاتيح العامة التي منها سيحصل هذا الموقع على المفتاح العام للأداة للسماح بالتحقق من تواقيع الرسائل المستلمة وطلبات الخدمة.';
$string['quickgrade'] = 'السماح بالتقييم السريع';
$string['quickgrade_help'] = 'إذا مُكّن، أدوات متعددة يمكن تقييمها في صفحة واحدة. أضف التقديرات والتعليقات ثم انقر زر "حفظ كل إفاداتي" لحفظ كل التغييرات لهذه الصفحة.';
$string['redirect'] = 'سيتم توجيهك في ثوان قليلة. إذا لم يتم، اضغط على الزر.';
$string['redirectionuris'] = 'إعادة توجيه الرابط (الروابط)';
$string['redirectionuris_help'] = 'قائمة بالروابط (واحدبكل سطر) التي تستخدمها الأداة عند تقديم طلبات التفويض. يجب تسجيل واحد على الأقل قبل إرسال الرسالة بنجاح إلى الأداة.';
$string['register'] = 'التسجيل';
$string['register_warning'] = 'يبدو أن صفحة التسجيل تستغرق بعض الوقت لفتحها. إذا لم تظهر، فتحقق من إدخال الرابط الصحيح في إعدادات التهيئة. إذا كان مودل يستعمل https، فتأكد من أن الأداة التي تقوم بتهيئتها تدعم https وأنك تستعمل https في الرابط.';
$string['registertype'] = 'تهيئة تسجيل أداة خارجية جديدة';
$string['registration_options'] = 'خيارات التسجيل';
$string['registrationname'] = 'اسم مزود الأداة';
$string['registrationname_help'] = 'أدخل اسم مزود الأداة المسجل.';
$string['registrationurl'] = 'رابط التسجيل';
$string['registrationurl_help'] = 'رابط التسجيل يجب أن يكون متاحًا من مزود الأداة باعتباره الموقع الذي يجب إرسال طلبات التسجيل إليه.';
$string['reject'] = 'رفض';
$string['rejected'] = 'مرفوض';
$string['resource'] = 'مصدر';
$string['resourcekey'] = 'اسم المستفيد';
$string['resourcekey_admin'] = 'اسم المستفيد';
$string['resourcekey_admin_help'] = 'يمكن اعتبار مفتاح المستفيد بمثابة اسم المستخدم الذي يستعمل لمصادقة الوصول إلى الأداة.
يمكن استعماله من قبل مزود الأداة لتمييز موقع مودل بشكل فريد حيث ينطلق المستخدمون بالأداة.

يجب توفير مفتاح المستفيد من قبل مزود الأداة. طريقة الحصول على مفتاح المستفيد تختلف ما بين المزودين. قد تكون عملية مؤتمتة، أو قد تتطلب إجراء حوار مع مزود الأداة.

الأدوات التي لا تتطلب اتصال آمن من مودل ولا توفر خدمات إضافية (مثل تقارير التقديرات) قد لا تتطلب سرًا مشتركًا.';
$string['resourcekey_help'] = 'للأدوات التي تمت تهيئتها مسبقًا، فإنه ليس من الضروري إدخال السر المشترك هنا، نظرًا لأنه سيتم توفيره كجزء من عملية التهيئة.

يجب إدخال هذا الحقل إذا أنشئ رابط إلى مزود الأداة التي لم تتم تهيئتها بالفعل.
إذا كان مزود الأداة سيستعمل أكثر من مرة في هذا المقرر، فتهيئة الأداة على مستوى المقرر فكرة جيدة.

يمكن اعتبار مفتاح المستفيد بمثابة اسم المستخدم الذي يستعمل لمصادقة الوصول إلى الأداة.
يمكن استعماله من قبل مزود الأداة لتمييز موقع مودل بشكل فريد حيث ينطلق المستخدمون بالأداة.

يجب توفير مفتاح المستفيد من قبل مزود الأداة. طريقة الحصول على مفتاح المستفيد تختلف ما بين المزودين. قد تكون عملية مؤتمتة، أو قد تتطلب إجراء حوار مع مزود الأداة.

الأدوات التي لا تتطلب اتصال آمن من مودل ولا توفر خدمات إضافية (مثل تقارير التقديرات) قد لا تتطلب سرًا مشتركًا.';
$string['resourceurl'] = 'رابط المورد';
$string['return_to_course'] = 'أنقر <a href="{$a->link}" target="_top">هنا</a> للعودة إلى المقرر الدراسي.';
$string['saveallfeedback'] = 'حفظ كل إفاداتي';
$string['search:activity'] = 'الأداة الخارجية - معلومات النشاط';
$string['secure_icon_url'] = 'رابط أيقونة  آمن';
$string['secure_icon_url_help'] = 'على غرار رابط الأيقونة، ولكنه يستعمل للوصول بشكل آمن من خلال SSL. الغرض من هذا الحقل هو منع المتصفح من تحذير المستخدم بشأن صورة غير آمنة.';
$string['secure_launch_url'] = 'رابط أداة آمن.';
$string['secure_launch_url_help'] = 'على غرار رابط الأداة، لكنها تستعمل بدلاً من رابط الأداة إذا كان مطلوبًا مستوى أمان مشدد. سيستعمل مودل رابط الأداة الآمن بدلاً من رابطها العادي إذا تم الوصول إلى موقع مودل من خلال SSL، أو إذا تمت تهيئة الأداة بحيث تُطلق دائمًا من خلال SSL.

يمكن أيضا ضبط رابط الأداة إلى عنوان HTTPS لفرض الإطلاق عبر SSL، ويمكن ترك هذا الحقل فارغاً.';
$string['selectcontent'] = 'إختر المحتوى';
$string['send'] = 'أرسل';
$string['services'] = 'الخدمات';
$string['services_help'] = 'حدد تلك الخدمات التي ترغب في تقديمها لمزود الأداة. يمكن اختيار أكثر من خدمة.';
$string['setupoptions'] = 'خيارات الإعداد';
$string['share_email'] = 'مشاركة البريد الالكتروني للمُطلق مع الأداة';
$string['share_email_admin'] = 'مشاركة البريد الالكتروني للمُطلق مع الأداة';
$string['share_email_admin_help'] = 'حدد ما إذا كان سيتم مشاركة عنوان البريد الإلكتروني للمستخدم الذي يقوم بتشغيل الأداة مع موفر الأداة. قد يحتاج موفر الأداة إلى عناوين البريد الإلكتروني لمشغل الشبكة لتمييز المستخدمين بنفس الاسم في واجهة المستخدم ، أو إرسال رسائل بريد إلكتروني إلى المستخدمين بناءً على الإجراءات داخل الأداة.';
$string['share_email_help'] = 'حدد ما إذا كان سيتم مشاركة عنوان البريد الإلكتروني للمستخدم الذي يقوم بتشغيل الأداة مع موفر الأداة. قد يحتاج موفر الأداة إلى عناوين بريد المشغّل لتمييز المستخدمين بنفس الاسم ، أو إرسال رسائل بريد إلكتروني إلى المستخدمين استنادًا إلى إجراءات داخل الأداة. لاحظ أنه قد يتم تجاوز هذا الإعداد في تكوين الأداة.';
$string['share_name'] = 'مشاركة اسم المُطلق مع الأداة';
$string['share_name_admin'] = 'مشاركة اسم المُطلق مع الأداة';
$string['share_name_admin_help'] = 'تحديد ما إذا كان الاسم الكامل للمستخدم الذي أطلق الأداة تنبغي مشاركته من مزود الأداة. مزود الأداة قد يحتاج أسماء المطلقين لإظهار معلومات مفيدة ضمن الأداة.';
$string['share_name_help'] = 'تحديد ما إذا كان الاسم الكامل للمستخدم الذي أطلق الأداة تنبغي مشاركته من مزود الأداة.

مزود الأداة قد يحتاج أسماء المطلقين لإظهار معلومات مفيدة ضمن الأداة.

لاحظ أن هذا الإعداد يمكن تجاوزه في تهيئة الأداة.';
$string['share_roster'] = 'السماح للأداة بالوصول إلى قائمة هذا المقرر';
$string['share_roster_admin'] = 'يمكن للأداة الوصول إلى قائمة الدوري';
$string['share_roster_admin_help'] = 'تحديد ما إذا كانت الأداة يمكن لها الوصول إلى قائمة المستخدمين المنضمين في المقررات الدراسية التي أطلقت هذا النوع من الأدوات.';
$string['share_roster_help'] = 'تحديد ما إذا كان الأداة يمكنها الوصول إلى قائمة  المستخدمين المنضمين في المقررات الدراسية.

لاحظ أن هذا الإعداد يمكن تجاوزه في تهيئة الأداة.';
$string['show_in_course_activity_chooser'] = 'إظهار في منتقي النشاطة وكأداة مُعدة مسبقًا';
$string['show_in_course_lti1'] = 'إعدادات التكوين المستخدمة';
$string['show_in_course_lti1_help'] = 'قد تظهر هذه الأداة في منتقي النشاطات ليختار المعلم إضافتها إلى المقرر الدراسي. بدلاً من ذلك، قد تظهر في القائمة المنسدلة المُعدة مسبقاً للأداة عند إضافة أداة خارجية إلى المقرر. هناك خيار آخر يتمثل في استعمال تهيئة الأداة فقط إذا تم إدخال رابط الأداة بالضبط عند إضافة أداة خارجية إلى المقرر الدراسي.';
$string['show_in_course_lti2'] = 'استخدام أداة التكوين';
$string['show_in_course_lti2_help'] = 'يمكن إظهار هذه الأداة في منتقي النشاط الذي يختار المعلم إضافتها إلى المادة أو في القائمة المنسدلة للأداة المعدة مسبقًا عند إضافة أداة خارجية إلى المادة.';
$string['show_in_course_no'] = 'لا تظهر؛ يستخدم فقط عند إدخال رابط لأداة المطابقة';
$string['show_in_course_preconfigured'] = 'الإظهار كأداة مُعدة مسبقاً عند إضافة الأداة الخارجية';
$string['sitehost'] = 'اسم مضيف الموقع';
$string['siteid'] = 'مُعرَّف الموقع';
$string['size'] = 'معاملات الحجم';
$string['submission'] = 'تقديم';
$string['submissions'] = 'التقديمات';
$string['submissionsfor'] = 'التقديمات لـ {$a}';
$string['subplugintype_ltiresource'] = 'مورد خدمة LTI';
$string['subplugintype_ltiresource_plural'] = 'موارد خدمة LTI';
$string['subplugintype_ltiservice'] = 'خدمة LTI';
$string['subplugintype_ltiservice_plural'] = 'خدمات LTI';
$string['subplugintype_ltisource'] = 'مصدر LTI';
$string['subplugintype_ltisource_plural'] = 'مصادر LTI';
$string['successfullycreatedtooltype'] = 'تم إنشاء أداة جديدة بنجاح!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'جلب أداة التكوين بنجاح من المحتوى المحدد.';
$string['toggle_debug_data'] = 'تبديل بيانات التصحيح';
$string['tool_config_not_found'] = 'لم يتم العثور على تكوين عنوان الأداة هذه .';
$string['tool_settings'] = 'إعدادات الأداة';
$string['tooldescription'] = 'وصف الأداة';
$string['tooldescription_help'] = 'وصف الأداة التي سيتم عرضها للمعلمين في قائمة الأنشطة. يجب أن يصف هذا الغرض من الأداة وماذا تفعل وأي معلومات إضافية قد يحتاج المعلم إلى معرفتها.';
$string['tooldetailsaccesstokenurl'] = 'عنوان URL لرمز الوصول';
$string['tooldetailsauthrequesturl'] = 'عنوان URL لطلب المصادقة';
$string['tooldetailsclientid'] = 'معرف العميل';
$string['tooldetailsdeploymentid'] = 'معرف النشر';
$string['tooldetailsmailtosubject'] = 'تكوين أداة LTI';
$string['tooldetailsmodalemail'] = 'البريد الإلكتروني';
$string['tooldetailsmodallink'] = 'عرض تفاصيل التكوين';
$string['tooldetailsmodaltitle'] = 'تفاصيل التكوين أداة';
$string['tooldetailsplatformid'] = 'مُعرَّف المنصة';
$string['tooldetailspublickeyseturl'] = 'عنوان URL لمجموعة المفاتيح العامة';
$string['toolisbeingused'] = 'يتم استخدام هذه الأداة {$a} مرات';
$string['toolisnotbeingused'] = 'لم يتم استخدام هذه الأداة بعد';
$string['toolproxy'] = 'تسجيلات الأداة الخارجية';
$string['toolproxy_help'] = 'تسمح تسجيلات الأدوات الخارجية لمسؤولي موقع مودل بتهيئة أدوات خارجية من وكيل للأدوات يتم الحصول عليها من موفر أداة يدعم LTI 2.0. عنوان رابط التسجيل الذي يقدمه موفر الأداة هو كل ما هو مطلوب لبدء العملية. يتم تحديد القدرات والخدمات المقدمة لمزود الأداة عند تهيئة التسجيل الجديد.

يتم تقسيم تسجيلات الأدوات المدرجة في هذه الصفحة إلى أربع فئات:

* **مهيأة** - تم إعداد تسجيلات الأداة هذه ولكن لم تبدأ عملية التسجيل بعد.
* **قيد الانتظار** - بدأت عملية التسجيل الخاصة بهذه التسجيلات للأداة ولكنها لم تكتمل. إفتح الإعدادات واحفظها لنقلها مرة أخرى إلى فئة \'مهيأة\'.
* **مقبول** - تمت الموافقة على تسجيلات الأدوات هذه؛ ستظهر الموارد المحددة في وكيل الأداة على صفحة الأدوات التي سبقت تهيأتها وستكون حالتها الأولية \'قيد الانتظار\'.
* **مرفوضة** - هذه التسجيلات للأداة هي تلك التي تم رفضها في أثناء عملية التسجيل. افتح الإعدادات واحفظها لإعادتها مرة أخرى إلى فئة \'مهيأة\' حتى يمكن معاودة عملية التسجيل.';
$string['toolproxyregistration'] = 'تسجيل الأداة الخارجية';
$string['toolregistration'] = 'تسجيل الأداة الخارجية';
$string['toolsetup'] = 'تهيئة الأداة الخارجية';
$string['tooltypeadded'] = 'تمت إضافة الأداة المعدة مسبقًا';
$string['tooltypedeleted'] = 'تم حذف أداة التكوين المسبق';
$string['tooltypenotdeleted'] = 'لا يمكن حذف الأداة المعدة مسبقا';
$string['tooltypes'] = 'أدوات';
$string['tooltypeupdated'] = 'تم تحديث أداة التكوين المسبق';
$string['toolurl'] = 'رابط قاعدة الأداة';
$string['toolurl_contentitemselectionrequest'] = 'عنوان URL لاختيار المحتوى';
$string['toolurl_contentitemselectionrequest_help'] = 'سيتم استخدام عنوان URL الخاص باختيار المحتوى لبدء تشغيل صفحة اختيار المحتوى من موفر الأداة. إذا كان فارغًا ، فسيتم استخدام عنوان URL للأداة';
$string['toolurl_help'] = 'يستعمل عنوان رابط الأداة لمطابقة عناوين الأداة مع التهيئة الصحيحة لها. إسباق العنوان بـ http/https هو أمر إختياري.

فضلاً عن ذلك، يستعمل مبنى عنوان الرابط بمابة عنوان رابط الأداة إذا لم يتم تحديد عنوان رابطها في عينة الأداة الخارجية.


على سبيل المثال، مبنى عنوان الرابط لـ *tool.com* سيطابق ما يأتي:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

مبنى عنوان الرابط لـ *www.tool.com/quizzes* سيطابق ما يأتي:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

مبنى عنوان الرابط لـ *quiz.tool.com* سيطابق ما يأتي:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

إذا كانت هناك إعدادات تهيئة مختلفة للأداة لنفس المجال، سيتم استعمال المطابقة الأكثر تحديداً.

يمكنك أيضاً إدراج عبوة عنوان الرابط إذا كان لديك، وتفاصيل الأداة ستتم تعبئتها تلقائياً.';
$string['toolurlplaceholder'] = 'عنوان URL للأداة ...';
$string['typename'] = 'اسم الأداة';
$string['typename_help'] = 'يتم استعمال اسم الأداة لتحديد مزود الأداة داخل مودل. الاسم المدخل سوف يكون ظاهراً للمعلمين عند إضافة أدوات خارجية ضمن المقررات الدراسية.';
$string['types'] = 'أنواع';
$string['unabletocreatetooltype'] = 'غير قادر على إنشاء أداة';
$string['unabletofindtooltype'] = 'غير قادر على العثور على أداة لـ {$a->id}';
$string['unknownstate'] = 'دولة غير معروفة';
$string['update'] = 'تحديث';
$string['useraccountinformation'] = 'معلومات حساب المستخدم';
$string['userpersonalinformation'] = 'معلومات المستخدم الشخصية';
$string['using_tool_cartridge'] = 'باستخدام خرطوشة الأداة';
$string['using_tool_configuration'] = 'باستخدام أداة التكوين:';
$string['validurl'] = 'العنوان الصالح يجب أن يبدأ http(s)://';
$string['viewsubmissions'] = 'عرض شاشة التسليمات والعلامات';
